package com.xebialabs.deployit.plumbing;

import java.lang.reflect.Field;
import org.junit.BeforeClass;

import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.plugin.manager.config.ConfigWrapper;
import com.xebialabs.plugin.manager.metadata.XLProduct;

import static com.xebialabs.deployit.util.DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY;

import org.apache.commons.lang3.reflect.FieldUtils;

public class XLReleaseTest {

    static {
        System.setProperty("derby.stream.error.field", "org.apache.commons.io.output.NullOutputStream.NULL_OUTPUT_STREAM");
        ConfigWrapper.initWith(XLProduct.fromString("xl-release"));
    }

    @BeforeClass
    public static void boot() {
        LocalBooter.bootWithoutGlobalContext();
        PasswordEncrypter.init(DEFAULT_PASSWORD_ENCRYPTION_KEY);
    }

    public void setInternalState(Object target, String field, Object value) {
        Class<?> c = target.getClass();
        try {
            Field f = FieldUtils.getField(c, field, true);
            f.set(target, value);
        } catch (Exception e) {
            throw new RuntimeException(
                   String.format("Unable to set internal state of Field [%s] on an object of class [%s]", field, c.getSimpleName()), e);
        }
    }
}
