package com.xebialabs.xlrelease

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.util.DeployitKeys._
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xlrelease.sugar.AnswerSugar
import grizzled.slf4j.Logging
import org.scalatest._
import org.scalatest.funspec.AnyFunSpecLike
import org.scalatest.matchers.should.Matchers
import org.scalatestplus.mockito.MockitoSugar

trait XLReleaseScalaTest
  extends AnyFunSpecLike
  with Matchers
  with BeforeAndAfterAll
  with BeforeAndAfterEach
  with MockitoSugar
  with AnswerSugar
  with Logging
  with TestAuthentication {

  LocalBooter.bootWithoutGlobalContext()
  PasswordEncrypter.init(DEFAULT_PASSWORD_ENCRYPTION_KEY)

}
