package com.xebialabs.xlrelease.builder

import com.xebialabs.deployit.io.StreamWrappingOverthereFile
import com.xebialabs.xlrelease.builder.AttachmentBuilder._
import com.xebialabs.xlrelease.domain.{Attachment, Task}

import java.io.ByteArrayInputStream
import scala.jdk.CollectionConverters._

object AttachmentBuilder {

  val FILE_DATA: Array[Byte] = Array(0xCA.toByte, 0xFE.toByte, 0xBA.toByte, 0xBE.toByte)

  val FILE_NAME = "foobar.dat"

  val DEFAULT_CONTENT_TYPE = "application/octet-stream"

  def dummyData = new ByteArrayInputStream(FILE_DATA)

  def dummyFile = new StreamWrappingOverthereFile(FILE_NAME, new ByteArrayInputStream(FILE_DATA))

  def newAttachment(id: String) = AttachmentBuilder(Some(id))

  def newAttachment() = AttachmentBuilder()

}

case class AttachmentBuilder(id: Option[String] = None, file: Option[StreamWrappingOverthereFile] = None, task: Option[Task] = None) {

  def withFile(newFile: StreamWrappingOverthereFile): AttachmentBuilder = this.copy(file = Some(newFile))

  def withId(newId: String): AttachmentBuilder = this.copy(id = Some(newId))

  def forTask(task: Task): AttachmentBuilder = this.copy(task = Some(task))

  def build(): Attachment = {
    val a = new Attachment(getFile, DEFAULT_CONTENT_TYPE)
    id.foreach(a.setId)
    task.foreach(t => {
      t.setAttachments((t.getAttachments.asScala :+ a).asJava)
      t.getRelease.getAttachments.add(a)
    })
    a
  }

  private def getFile = file.getOrElse(dummyFile)

}
