package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class ReleaseTriggerAssertion extends AbstractAssert<ReleaseTriggerAssertion, ReleaseTrigger> {
    public ReleaseTriggerAssertion(ReleaseTrigger actual) {
        super(actual, ReleaseTriggerAssertion.class);
    }

    public ReleaseTriggerAssertion hasExecutionId() {
        isNotNull();
        Assertions.assertThat(actual.getExecutionId()).isNotNull();
        return this;
    }

    public ReleaseTriggerAssertion hasNoExecutionId() {
        isNotNull();
        Assertions.assertThat(actual.getExecutionId()).isNull();
        return this;
    }

    public ReleaseTriggerAssertion isDisabled() {
        Assertions.assertThat(actual.isEnabled()).isFalse();
        return this;
    }
}
