package com.xebialabs.xlrelease.upgrade.json;

import java.io.IOException;
import java.nio.charset.Charset;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import static com.xebialabs.xlrelease.ClassPathResources.getString;
import static java.nio.charset.StandardCharsets.UTF_8;

public class JsonUpgradeHelper {

    private static JSONObject readJson(String resourceName, Charset charset) throws IOException, JSONException {
        return new JSONObject(getString(resourceName, charset));
    }

    public static JSONObject readJson(String resourceName) throws IOException, JSONException {
        return readJson(resourceName, UTF_8);
    }
}
