package com.xebialabs.xlrelease.assertions;

import java.util.Date;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.PlanItem;

public class PlanItemAssertion<S extends AbstractAssert<S, A>, A extends PlanItem> extends AbstractAssert<S, A> {

    protected PlanItemAssertion(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public PlanItemAssertion hasId(String id) {
        isNotNull();
        Assertions.assertThat(actual.getId()).isEqualTo(id);
        return this;
    }

    public PlanItemAssertion hasStartDate() {
        isNotNull();
        Assertions.assertThat(actual.getStartDate()).isNotNull();
        return this;
    }

    public PlanItemAssertion hasStartDate(Date expectedStartDate) {
        isNotNull();
        Assertions.assertThat(actual.getStartDate()).isNotNull().isEqualTo(expectedStartDate);
        return this;
    }

    public PlanItemAssertion hasEndDate() {
        isNotNull();
        Assertions.assertThat(actual.getEndDate()).isNotNull();
        return this;
    }


    public PlanItemAssertion hasEndDate(Date expectedEndDate) {
        isNotNull();
        Assertions.assertThat(actual.getEndDate()).isNotNull().isEqualTo(expectedEndDate);
        return this;
    }

    public PlanItemAssertion hasNoEndDate() {
        isNotNull();
        Assertions.assertThat(actual.getEndDate()).isNull();
        return this;
    }

    public PlanItemAssertion hasScheduledStartDate() {
        isNotNull();
        Assertions.assertThat(actual.getScheduledStartDate()).isNotNull();
        return this;
    }

    public PlanItemAssertion hasScheduledStartDate(Date date) {
        isNotNull();
        Assertions.assertThat(actual.getScheduledStartDate()).isNotNull().isEqualTo(date);
        return this;
    }

    public PlanItemAssertion hasNoScheduledStartDate() {
        isNotNull();
        Assertions.assertThat(actual.getScheduledStartDate()).isNull();
        return this;
    }

    public PlanItemAssertion hasDueDate() {
        isNotNull();
        Assertions.assertThat(actual.getDueDate()).isNotNull();
        return this;
    }

    public PlanItemAssertion hasDueDate(Date date) {
        isNotNull();
        Assertions.assertThat(actual.getDueDate()).isNotNull().isEqualTo(date);
        return this;
    }

    public PlanItemAssertion hasOwner(String owner) {
        isNotNull();
        Assertions.assertThat(actual.getOwner()).isNotNull();
        return this;
    }

    public PlanItemAssertion hasNoStartDate() {
        isNotNull();
        Assertions.assertThat(actual.getStartDate()).isNull();
        return this;
    }

    public PlanItemAssertion hasFlagStatus(FlagStatus flagStatus) {
        isNotNull();
        Assertions.assertThat(actual.getFlagStatus()).isEqualTo(flagStatus);
        return this;
    }

    public PlanItemAssertion hasFlagComment(String flagComment) {
        isNotNull();
        Assertions.assertThat(actual.getFlagComment()).isEqualTo(flagComment);
        return this;
    }

    public PlanItemAssertion hasPlannedDuration(int plannedDuration) {
        isNotNull();
        Assertions.assertThat(actual.getPlannedDuration()).isEqualTo(plannedDuration);
        return this;
    }

    public PlanItemAssertion isInFolder(String folderId) {
        isNotNull();
        Assertions.assertThat(actual.getId()).startsWith(folderId);
        return this;
    }

    public PlanItemAssertion isOverdueNotified(boolean overdueNotified) {
        isNotNull();
        Assertions.assertThat(actual.isOverdueNotified()).isEqualTo(overdueNotified);
        return this;
    }

    public PlanItemAssertion hasCiAttributes(CiAttributes ciAttributes) {
        isNotNull();
        Assertions.assertThat(actual.get$ciAttributes()).isEqualToComparingOnlyGivenFields(ciAttributes, "scmTraceabilityDataId", "createdBy", "lastModifiedBy");
        return this;
    }
}
