package com.xebialabs.xlrelease.rules;

import org.junit.rules.ExternalResource;

import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.repository.WorkDirFactory;

// If using WorkDirRule with Java based integration tests, do not use @Rule on WorkDirRule
// before and after methods will not be executed in the order we would like to
// check AttachmentServiceIntegrationTest for example
public class WorkDirRule extends ExternalResource {

    private WorkDir initialWorkDir;

    public void before() throws Throwable {
        //WorkDirFactory is autowired by spring for integration tests. But we have to create it for unit tests.
        WorkDirFactory workDirFactory = new WorkDirFactory(System.getProperty("java.io.tmpdir"));
        new WorkDirContext(workDirFactory);
        WorkDirContext.initWorkdir();
        initialWorkDir = WorkDirContext.get();
    }

    public void after() {
        if (WorkDirContext.get() != null) {
            //This will make sure we are not initializing another WorkDir in code
            if (!initialWorkDir.getPath().equals(WorkDirContext.get().getPath())) {
                throw new RuntimeException(initialWorkDir.getPath() + " was not " + WorkDirContext.get().getPath());
            }
            WorkDirContext.get().delete();
            WorkDirContext.clear();
        }
    }
}
