package com.xebialabs.xlrelease.security.authority;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public final class TenantAuthority implements GrantedAuthority {

    private final String tenantId;

    public TenantAuthority(final String tenantId) {
        Assert.hasText(tenantId, "Tenant ID is required");
        this.tenantId = tenantId;
    }

    @Override
    public String getAuthority() {
        return this.tenantId;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TenantAuthority ta) {
            return this.tenantId.equals(ta.getAuthority());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.tenantId.hashCode();
    }

    @Override
    public String toString() {
        return this.tenantId;
    }
}
