package com.xebialabs.xlrelease.utils

import scala.collection.mutable

class MessageLogger {
  private val logBuffer: mutable.Buffer[String] = mutable.ArrayBuffer.empty
  private var depth: Int = 0
  val prefix = "    "

  def increaseDepth(): Unit = depth = depth + 1

  def decreaseDepth(): Unit = depth = depth - 1


  def log(msg: String): Unit = {
    logBuffer += s"${prefix * depth}$msg"
  }

  def msg: String = {
    logBuffer.mkString("\n", "\n", "\n")
  }
}
