package com.xebialabs.xlrelease.configuration

import com.xebialabs.xlrelease.configuration.ThemeColor._

object ThemeColors {

  def colorCode(themeColor: ThemeColor): String = themeColor match {
    case BLUE => "#3D6C9E"
    case GREEN => "#498500"
    case RED => "#D61F21"
    case ORANGE => "#FF9E49"
    case GRAY => "#667385"
    case PURPLE => "#991C71"
  }

  def themeColorFromCode: PartialFunction[String, ThemeColor] = {
    case "#3D6C9E" => BLUE
    case "#498500" => GREEN
    case "#D61F21" => RED
    case "#FF9E49" => ORANGE
    case "#667385" => GRAY
    case "#991C71" => PURPLE
  }

  def themeColorFromOldCode: PartialFunction[String, ThemeColor] = {
    case "#68b749" => BLUE
    case "#FF9E3B" => RED
    case "#DD4B39" => ORANGE
    case "#999999" => GRAY
    case "#991C71" => PURPLE
  }

  def fromOldCodeWithDefaultGreen(oldCode: String): ThemeColor =
    themeColorFromOldCode
      .lift
      .apply(oldCode.toUpperCase)
      .getOrElse(ThemeColor.GREEN)

}
