package com.xebialabs.xlrelease.support.cache.config

import com.typesafe.config.{Config, ConfigFactory}
import com.xebialabs.xlrelease.features.ToggleFeature
import com.xebialabs.xlrelease.support.config.TypesafeConfigExt.ExtendedConfig

trait CacheSettings {

  def configForCache(cacheName: String): Config

  def isEnabled(cacheName: String): Boolean
}

object CacheSettings {
  val DEFAULT_CACHE_VALUES = "default-cache-values"
}

class ConfigCacheSettings(config: Config, defaultConfigName: String = CacheSettings.DEFAULT_CACHE_VALUES) extends CacheSettings {

  override def isEnabled(cacheName: String): Boolean = configForCache(cacheName).getOptionalBoolean("enabled").getOrElse(true)

  override def configForCache(cacheName: String): Config = {
    val defaultCacheConfig: Config = config.getConfig(defaultConfigName)
    config.getOptionalConfig(cacheName).getOrElse(ConfigFactory.empty()).withFallback(defaultCacheConfig)
  }

  def withFeatureSettings(toggleFeature: ToggleFeature): FeatureCacheSettings = new FeatureCacheSettings(toggleFeature, config, defaultConfigName)
}

class FeatureCacheSettings(toggleFeature: ToggleFeature, config: Config, defaultConfigName: String = CacheSettings.DEFAULT_CACHE_VALUES)
  extends ConfigCacheSettings(config, defaultConfigName) {

  override def isEnabled(cacheName: String): Boolean = toggleFeature.isEnabled(Option(cacheName))
}

