package com.xebialabs.xlrelease.support.cache.caffeine.spring

import com.github.benmanes.caffeine.cache.{Cache, CacheLoader}
import com.xebialabs.xlrelease.support.cache.caffeine.CaffeineCacheBuilder
import com.xebialabs.xlrelease.support.cache.config.CacheSettings
import org.springframework.cache.caffeine.CaffeineCacheManager

class XlrCaffeineCacheManager(cacheManagerName: String, defaultCacheConfigName: String, cacheSettings: CacheSettings)
  extends CaffeineCacheManager with CaffeineCacheBuilder {

  override def createNativeCaffeineCache(name: String): Cache[AnyRef, AnyRef] = {
    buildCache(cacheManagerName, name, defaultCacheConfigName, cacheSettings.config)
  }

  override def setCacheLoader(cacheLoader: CacheLoader[AnyRef, AnyRef]): Unit = {
    throw new UnsupportedOperationException("Cache loading not support by this manager implementation")
  }

}
