package com.xebialabs.xlrelease.plugin.manager.validator

//  warnings = things we want to tell the user but not actually fail the install/update
//  errors = things that will fail the install/update
case class TypeChangeValidationResults(warnings: Seq[String], errors: Seq[String]) {
  def ++(that: TypeChangeValidationResults): TypeChangeValidationResults = {
    TypeChangeValidationResults(this.warnings ++ that.warnings, this.errors ++ that.errors)
  }
}

object TypeChangeValidationResults {
  def empty(): TypeChangeValidationResults = TypeChangeValidationResults(Seq.empty[String], Seq.empty[String])
}

trait TypeChangeValidator {
  def validate(changes: Seq[Change]): TypeChangeValidationResults
}


