package com.xebialabs.xlrelease.plugin.manager.validator

import com.xebialabs.plugin.manager.validator.{RestartNeeded, TypeSystemValidationResults}
import com.xebialabs.xlrelease.plugin.JarPlugin

class JarPluginValidator extends XlrPluginValidator {
  override def validate: Validate = {
    case plugin: JarPlugin => validateJarPlugin(plugin)
  }

  private def validateJarPlugin(plugin: JarPlugin): TypeSystemValidationResults = {
    // TODO: S-92951 consider additional validation for jar plugins
    RestartNeeded(plugin.file.getName, Seq.empty)
  }
}
