package com.xebialabs.xlrelease.plugin

import com.xebialabs.xlrelease.plugin.JarBasedPlugin.PathUtils
import de.schlichtherle.truezip.util.UriEncoder
import de.schlichtherle.truezip.util.UriEncoder.Encoding

import java.net.URL

trait JarBasedPlugin extends Plugin {
  private lazy val handler = new NonCachingJarResourceURLStreamHandler()

  def toJarURL(libraryPath: String, entry: String): URL = {
    new URL("jar", "", -1, s"file:/${libraryPath.dropFirstSlash.encoded}!/${entry.encoded}", handler)
  }
}

object JarBasedPlugin {
  implicit class PathUtils(val path: String) extends AnyVal {
    def encoded: String = new UriEncoder().encode(path, Encoding.PATH)

    def dropFirstSlash: String = path.dropWhile(_ == '/')
  }
}
