/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.booter;

import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.model.FilePlugin;
import com.xebialabs.plugin.manager.model.FilePlugin$;
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.xlplatform.sugar.PathSugar$;
import com.xebialabs.xlrelease.booter.XlrBooter;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.system.PluginReloaded;
import com.xebialabs.xlrelease.events.system.TypesReloaded;
import com.xebialabs.xlrelease.events.system.distributed.ReloadPlugin;
import com.xebialabs.xlrelease.plugin.classloading.XlrPluginClassLoader;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Marker;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.FileSystemUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.convert.StreamExtensions;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.StreamConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q4AAC\u0006\u0001)!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b9\u0003A\u0011A(\t\u000b\u0005\u0004A\u0011\u00022\t\u000b=\u0004A\u0011\u00029\t\u000bI\u0004A\u0011B:\u0003+ac'\u000f\u00157vO&tWI^3oi\"\u000bg\u000e\u001a7fe*\u0011A\"D\u0001\u0007E>|G/\u001a:\u000b\u00059y\u0011!\u0003=me\u0016dW-Y:f\u0015\t\u0001\u0012#A\u0005yK\nL\u0017\r\\1cg*\t!#A\u0002d_6\u001c\u0001aE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0001\u0013\u0001C4sSjTH.\u001a3\n\u0005\tj\"a\u0002'pO\u001eLgnZ\u0001\tKZ,g\u000e\u001e\"vgB\u0011Q\u0005K\u0007\u0002M)\u0011q%D\u0001\u0007KZ,g\u000e^:\n\u0005%2#\u0001C#wK:$()^:\u0002\u0015AdWoZ5og\u0012K'\u000f\u0005\u0002-g5\tQF\u0003\u0002/_\u0005!a-\u001b7f\u0015\t\u0001\u0014'A\u0002oS>T\u0011AM\u0001\u0005U\u00064\u0018-\u0003\u00025[\t!\u0001+\u0019;i\u0003A\u0001H.^4j]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00028\u00016\t\u0001H\u0003\u0002:u\u0005\u00191/\u001d7\u000b\u0005mb\u0014A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011QHP\u0001\b[\u0006t\u0017mZ3s\u0015\tyt\"\u0001\u0004qYV<\u0017N\\\u0005\u0003\u0003b\u00121cU9m!2,x-\u001b8SKB|7/\u001b;pef\f\u0011\u0002\u001f7s\u0005>|G/\u001a:\u0011\u0005\u0011+U\"A\u0006\n\u0005\u0019[!!\u0003-me\n{w\u000e^3s\u0003\u0019a\u0014N\\5u}Q)\u0011JS&M\u001bB\u0011A\t\u0001\u0005\u0006G\u0015\u0001\r\u0001\n\u0005\u0006U\u0015\u0001\ra\u000b\u0005\u0006k\u0015\u0001\rA\u000e\u0005\u0006\u0005\u0016\u0001\raQ\u0001\b_:,e/\u001a8u)\t\u00016\u000b\u0005\u0002\u0017#&\u0011!k\u0006\u0002\u0005+:LG\u000fC\u0003U\r\u0001\u0007Q+A\u0003fm\u0016tG\u000f\u0005\u0002W76\tqK\u0003\u0002Y3\u0006YA-[:ue&\u0014W\u000f^3e\u0015\tQf%\u0001\u0004tsN$X-\\\u0005\u00039^\u0013ABU3m_\u0006$\u0007\u000b\\;hS:D#A\u00020\u0011\u0005\u0015z\u0016B\u00011'\u00059\t5/\u001f8d'V\u00147o\u0019:jE\u0016\f!b]=oGBcWoZ5o)\t\u0019\u0017\u000e\u0005\u0002eO6\tQM\u0003\u0002gc\u0005\u0011\u0011n\\\u0005\u0003Q\u0016\u0014AAR5mK\")!n\u0002a\u0001W\u0006A\u0001\u000f\\;hS:LE\r\u0005\u0002m[6\tA(\u0003\u0002oy\tA\u0001\u000b\\;hS:LE-\u0001\fsK6|g/\u001a)sKZLw.^:WKJ\u001c\u0018n\u001c8t)\t\u0001\u0016\u000fC\u0003k\u0011\u0001\u00071.\u0001\bxe&$X\rT8dC24\u0015\u000e\\3\u0015\u0007\r$8\u0010C\u0003@\u0013\u0001\u0007Q\u000f\u0005\u0002ws6\tqO\u0003\u0002yy\u0005)Qn\u001c3fY&\u0011!p\u001e\u0002\t\t\n\u0004F.^4j]\")!.\u0003a\u0001W\u0002")
public class XlrPluginEventHandler
implements Logging {
    private final EventBus eventBus;
    private final Path pluginsDir;
    private final SqlPluginRepository pluginRepository;
    private final XlrBooter xlrBooter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XlrPluginEventHandler xlrPluginEventHandler = this;
        synchronized (xlrPluginEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @AsyncSubscribe
    public void onEvent(ReloadPlugin event) {
        PluginId pluginId = event.pluginId();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        XlrPluginClassLoader pluginClassLoader = (XlrPluginClassLoader)tccl;
        File pluginFile = (File)pluginClassLoader.withWriteLock((Function0 & Serializable)() -> {
            pluginClassLoader.closePlugin(pluginId);
            return this.syncPlugin(pluginId);
        });
        pluginClassLoader.reload(pluginId, pluginFile);
        this.eventBus.publish((XLReleaseEvent)new PluginReloaded(pluginId));
        this.xlrBooter.reboot();
        this.eventBus.publish((XLReleaseEvent)new TypesReloaded());
    }

    private File syncPlugin(PluginId pluginId) {
        this.removePreviousVersions(pluginId);
        Seq seq = this.pluginRepository.getByNameAndVersion(pluginId.name(), pluginId.version());
        if (seq.size() == 1) {
            return this.writeLocalFile((DbPlugin)seq.head(), pluginId);
        }
        if (seq.size() > 1) {
            throw new IllegalStateException("Unable to install plugin " + pluginId + ": too many plugins matching name and version");
        }
        throw new IllegalStateException("Unable to install plugin " + pluginId + ": plugin not found in the database");
    }

    private void removePreviousVersions(PluginId pluginId) {
        List plugins = ((List)StreamConverters$.MODULE$.StreamHasToScala(Files.walk(this.pluginsDir, new FileVisitOption[0]).filter(x$1 -> PathSugar$.MODULE$.path2File(x$1).isFile()).filter(file -> ConfigWrapper$.MODULE$.isValidExtension(file.toFile().getName()))).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).map((Function1 & Serializable)x$2 -> FilePlugin$.MODULE$.apply(x$2)).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XlrPluginEventHandler.$anonfun$removePreviousVersions$4(pluginId, x$3)));
        plugins.foreach((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)XlrPluginEventHandler.$anonfun$removePreviousVersions$5(this, plugin)));
    }

    private File writeLocalFile(DbPlugin plugin, PluginId pluginId) {
        Option option = plugin.bytes();
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] pluginBytes = (byte[])some.value();
            File targetFile = new File(pluginId.pluginFilePath(this.pluginsDir));
            FileCopyUtils.copy((byte[])pluginBytes, (File)targetFile);
            this.pluginRepository.update((SqlPluginRepository.UpdateCommand)new SqlPluginRepository.UpdatePluginStatus(plugin.name(), PluginStatus$.MODULE$.INSTALLED()));
            return targetFile;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Unable to install plugin " + pluginId + ": no content found in the database");
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$removePreviousVersions$4(PluginId pluginId$2, FilePlugin x$3) {
        String string = x$3.name();
        String string2 = pluginId$2.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removePreviousVersions$5(XlrPluginEventHandler $this, FilePlugin plugin) {
        boolean bl;
        $this.logger().warn((Function0 & Serializable)() -> "Deleting previously installed plugin: " + plugin.filePath());
        try {
            bl = FileSystemUtils.deleteRecursively((File)plugin.filePath().toFile());
        }
        catch (Exception ex) {
            $this.logger().error((Function0 & Serializable)() -> "Unable to delete " + plugin.name(), (Function0 & Serializable)() -> ex);
            throw ex;
        }
        return bl;
    }

    public XlrPluginEventHandler(EventBus eventBus, Path pluginsDir, SqlPluginRepository pluginRepository, XlrBooter xlrBooter) {
        this.eventBus = eventBus;
        this.pluginsDir = pluginsDir;
        this.pluginRepository = pluginRepository;
        this.xlrBooter = xlrBooter;
        Logging.$init$((Logging)this);
    }
}

