package com.xebialabs.xlrelease.plugin.manager.validator

import com.xebialabs.deployit.plugin.api.reflect.{InputHint, InputHintValue, PropertyKind, Type}

import scala.jdk.CollectionConverters.ListHasAsScala
import scala.math.Ordered.orderingToOrdered
import scala.math.Ordering.Implicits.seqOrdering

class InputHintComparator extends java.util.Comparator[InputHint] {
  override def compare(o1: InputHint, o2: InputHint): Int = {
    if (o1 == null && o2 == null) return 0
    if (o1 == null) return -1
    if (o2 == null) return 1

    implicit val propertyKindOrdering: Ordering[PropertyKind] = Ordering.by(_.name)
    implicit val inputHintValuesOrdering: Ordering[Seq[InputHintValue]] = Ordering.by((seq: Seq[InputHintValue]) => seq.map(entry => (entry.getValue, entry.getLabel)))
    implicit val typeOrdering: Ordering[Type] = Ordering.by(v => (v.getName, v.getPrefix))

    // we don't compare validationRules because Release do not support it
    Seq(
      compare(o1.getKind, o2.getKind),
      compare(o1.isRequired, o2.isRequired),
      compare(o1.getPrompt, o2.getPrompt),
      compare(o1.getValues.asScala.toSeq, o2.getValues.asScala.toSeq),
      compare(o1.getCopyFromProperty, o2.getCopyFromProperty),
      compare(o1.getReferencedType, o2.getReferencedType),
      compare(o1.getMethodRef, o2.getMethodRef),
      compare(o1.isDynamicLookup, o2.isDynamicLookup)
    ).find(_ != 0).getOrElse(0)
  }

  private def compare[T: Ordering](field1: T, field2: T): Int = (Option(field1), Option(field2)) match {
    case (None, None) => 0
    case (None, _) => -1
    case (_, None) => 1
    case (Some(f1), Some(f2)) => f1.compare(f2)
  }
}

object InputHintComparator {
  private lazy val comparator = new InputHintComparator()
  def notEqual(o1: InputHint, o2: InputHint): Boolean = comparator.compare(o1, o2) != 0
}
