/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.form.CreateVersionForm;
import com.xebialabs.xlrelease.api.v1.views.VersionComparisonView;
import com.xebialabs.xlrelease.api.v1.views.VersionInfo;
import com.xebialabs.xlrelease.api.v1.views.VersionsView;
import com.xebialabs.xlrelease.domain.versioning.ascode.FoldersWithAppliedVersionInfo;
import com.xebialabs.xlrelease.domain.versioning.ascode.GitBranch;
import com.xebialabs.xlrelease.domain.versioning.ascode.VersioningStyle;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReport;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessage;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;

@Path(value="api/v1/version-control")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface FolderVersioningApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "folderVersioningApi";
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    @PublicApiMember
    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String var1);

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    @PublicApiMember
    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String var1, FolderVersioningSettings var2);

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    @PublicApiMember
    public void deleteSettings(@PathParam(value="folderId") String var1);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    @PublicApiMember
    public VersionsView getVersions(@PathParam(value="folderId") String var1, @DefaultValue(value="false") @QueryParam(value="fetchChanges") Boolean var2);

    @PublicApiMember
    public VersionsView getVersions(String var1);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/branches")
    public List<GitBranch> getAllBranches(@PathParam(value="folderId") String var1, @QueryParam(value="configId") String var2);

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionInfo createVersion(@PathParam(value="folderId") String var1, CreateVersionForm var2);

    @PublicApiMember
    public VersionInfo createVersion(String var1, String var2, String var3);

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/apply")
    @PublicApiMember
    public ValidationReport applyVersion(@PathParam(value="folderId") String var1, @PathParam(value="version") String var2);

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/preview")
    public String previewCurrent(@PathParam(value="folderId") String var1, @QueryParam(value="filename") String var2);

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/preview")
    public String previewVersion(@PathParam(value="folderId") String var1, @PathParam(value="version") String var2, @QueryParam(value="filename") String var3);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/getVersionedFileNames")
    @PublicApiMember
    public List<String> getVersionedFileNames(@PathParam(value="folderId") String var1, @PathParam(value="version") String var2);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/getVersionableFileNames")
    @PublicApiMember
    public List<String> getCurrentVersionableFileNames(@PathParam(value="folderId") String var1);

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/delete-local-repo")
    public void deleteLocalRepo(@PathParam(value="folderId") String var1, @DefaultValue(value="false") @QueryParam(value="clusterWide") Boolean var2);

    public void deleteLocalRepo(String var1);

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/reset-local-repo")
    public void resetLocalRepo(@PathParam(value="folderId") String var1, @DefaultValue(value="false") @QueryParam(value="clusterWide") Boolean var2);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validate")
    @PublicApiMember
    public ValidationReport validateCurrent(@PathParam(value="folderId") String var1);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    @PublicApiMember
    public ValidationReport getValidationMessages(@PathParam(value="folderId") String var1);

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    public void setValidationMessages(@PathParam(value="folderId") String var1, ValidationReport var2);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/")
    @PublicApiMember
    public ValidationReportMessage getValidationMessage(@PathParam(value="folderId") String var1, @PathParam(value="messageId") String var2);

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/update")
    public void setValidationMessagesStatus(@PathParam(value="folderId") String var1, @PathParam(value="messageId") String var2, ValidationReportMessage var3);

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/clear-secrets")
    public void clearSecrets(@PathParam(value="folderId") String var1);

    @GET
    @Path(value="/styles")
    public List<VersioningStyle> getVersioningStyles();

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/compare-file")
    public String compareFileVersions(@PathParam(value="folderId") String var1, @QueryParam(value="fileName") String var2, @QueryParam(value="leftVersion") String var3, @QueryParam(value="rightVersion") String var4);

    public String compareFileVersionWithCurrent(String var1, String var2, String var3);

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/compare-versions")
    public VersionComparisonView compareVersions(@PathParam(value="folderId") String var1, @QueryParam(value="leftVersion") String var2, @QueryParam(value="rightVersion") String var3);

    public VersionComparisonView compareVersionWithCurrent(String var1, String var2);

    @GET
    @Path(value="/all-folders-applied-version")
    public List<FoldersWithAppliedVersionInfo> getVersionedFolderInfo();
}

