package com.xebialabs.xlrelease.api.v1;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import org.springframework.data.domain.Page;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.WorkflowFilters;
import com.xebialabs.xlrelease.api.v1.views.WorkflowOverview;

@Path("/api/v1/workflows")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface WorkflowApi extends ApiService {

    default String serviceName() {
        return "WorkflowApi";
    }

    @POST
    @Path("search")
    Page<WorkflowOverview> searchWorkflows(WorkflowFilters workflowFilters,
                                           @DefaultValue("0") @QueryParam(PAGE) int page,
                                           @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) int resultsPerPage);
}
