/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlrelease.api.v1.forms.TenantLinkRequest;
import com.xebialabs.xlrelease.api.v1.forms.TenantRequest;
import com.xebialabs.xlrelease.configuration.TenantLimit;
import com.xebialabs.xlrelease.domain.Tenant;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;

@Path(value="/api/v1/tenants")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface TenantApi {
    @GET
    public List<Tenant> getTenants();

    @GET
    @Path(value="/{tenantId}")
    public Tenant getTenant(@PathParam(value="tenantId") String var1);

    @POST
    public Tenant create(TenantRequest var1);

    @PUT
    @Path(value="/{tenantId}")
    public void update(@PathParam(value="tenantId") String var1, TenantRequest var2);

    @DELETE
    @Path(value="/{tenantId}")
    public void delete(@PathParam(value="tenantId") String var1);

    @GET
    @Path(value="/limits")
    public List<TenantLimit> getLimits();

    @GET
    @Path(value="/limits/{tenantId}")
    public TenantLimit getLimit(@PathParam(value="tenantId") String var1);

    @POST
    @Path(value="/limits/{tenantId}")
    public TenantLimit createLimit(@PathParam(value="tenantId") String var1, TenantLimit var2);

    @PUT
    @Path(value="/limits/{tenantId}")
    public void updateLimit(@PathParam(value="tenantId") String var1, TenantLimit var2);

    @DELETE
    @Path(value="/limits/{tenantId}")
    public void deleteLimit(@PathParam(value="tenantId") String var1);

    @PUT
    @Path(value="/{tenantId}/link")
    public void linkResource(@PathParam(value="tenantId") String var1, List<TenantLinkRequest> var2);
}

