/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentReservationForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentReservationView;
import com.xebialabs.xlrelease.api.v1.views.search.EnvironmentReservationSearchView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.rest.AllCILevels;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Path(value="/api/v1/environments/reservations")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface EnvironmentReservationApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "environmentReservationApi";
    }

    @POST
    public EnvironmentReservationView createReservation(EnvironmentReservationForm var1);

    @GET
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public EnvironmentReservationView getReservation(@PathParam(value="environmentReservationId") String var1);

    @PUT
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public EnvironmentReservationView updateReservation(@PathParam(value="environmentReservationId") String var1, EnvironmentReservationForm var2);

    @POST
    @Path(value="/search")
    public List<EnvironmentReservationSearchView> searchReservations(ReservationFilters var1);

    @DELETE
    @PublicApiMember
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public void delete(@PathParam(value="environmentReservationId") String var1);

    @POST
    @PublicApiMember
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public void addApplication(@PathParam(value="environmentReservationId") String var1, @QueryParam(value="applicationId") String var2);

    @PublicApiMember
    public EnvironmentReservation create(EnvironmentReservation var1);

    @PublicApiMember
    public EnvironmentReservation getById(String var1);

    @PublicApiMember
    public EnvironmentReservation update(EnvironmentReservation var1);

    @PublicApiMember
    public Map<String, List<EnvironmentReservation>> search(ReservationFilters var1);

    @PublicApiMember
    public boolean hasReservation(String var1, String var2);

    @PublicApiMember
    public Date nearestComingReservation(String var1, String var2);
}

