package com.xebialabs.xlrelease.api.v1;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.domain.UserToken;

/**
 * Operations related to personal access tokens.
 * This is a public API restricted for release remote runners for now and thus why it is not documented.
 */
@Path("/api/v1/personal-access-tokens")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface PersonalAccessTokenApi extends ApiService {

    default String serviceName() {
        return "personalAccessTokenApi";
    }

    /**
     * Creates a personal access token for other internal user. Supported only for Release administrators.
     *
     * @param createPersonalAccessTokenForm The personal access token properties
     * @return the new personal access token created
     */
    @POST
    @Path("/{username}")
    UserToken createPersonalAccessToken(@PathParam("username") String username,
                                        CreatePersonalAccessTokenForm createPersonalAccessTokenForm);

    /**
     * Creates a personal access token for authenticated user
     *
     * @param createPersonalAccessTokenForm The personal access token properties
     * @return the new personal access token created
     */
    @POST
    UserToken createPersonalAccessToken(CreatePersonalAccessTokenForm createPersonalAccessTokenForm);

}
