package com.xebialabs.xlrelease.api.v1;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.DeploymentServerSetup;
import com.xebialabs.xlrelease.domain.environments.LiveDeployment;
import com.xebialabs.xlrelease.views.AutoconfigResponse;

@Path("/api/v1/deployment-servers")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface DeploymentServerApi extends ApiService {

    default String serviceName() {
        return "deploymentServerApi";
    }

    @POST
    @Path("/autoconfigure/{statusWebhookEventSourceId:.*/Configuration[^/]*}")
    AutoconfigResponse autoconfigureDeploymentServer(@PathParam("statusWebhookEventSourceId") String statusWebhookEventSourceId);

    @POST
    @Path("/patch/{statusWebhookEventSourceId:.*/Configuration[^/]*}")
    void patchDeploymentServer(@PathParam("statusWebhookEventSourceId") String statusWebhookEventSourceId);

    @POST
    @Path("/setup")
    String setupDeploymentServer(DeploymentServerSetup deploymentServerSetup);

    @GET
    @Path("/live-deployment/{deploymentId}")
    LiveDeployment getLiveDeployment(@PathParam("deploymentId") String deploymentId);
}
