package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;

/**
 * Operations on activity logs.
 */
@Path("/api/v1/activities")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
public interface ActivityLogsApi extends ApiService {

    default String serviceName() {
        return "activityLogsApi";
    }

    /**
     * Gets List of activity logs.
     *
     * @param containerId the identifier of the release, template, delivery or pattern
     * @return the activity logs
     */
    @GET
    @Path("/{containerId:.*/(Release|Delivery|Trigger)[^/]*}")
    @PublicApiMember
    List<ActivityLogEntry> getActivityLogs(@PathParam("containerId") String containerId);
}
