package com.xebialabs.xlrelease.api.v1;

import java.util.Map;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

@Path("/api/v1/settings")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface SettingsApi extends ApiService {

    default String serviceName() {
        return "settingsApi";
    }

    @GET
    @Path("{ID:Configuration/settings.*}")
    BaseConfiguration getSettings(@PathParam("ID") String id);

    @GET
    @Path("instance-information")
    Map<String, String> getInstanceInformation();
}
