package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentStageFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentStageForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentStageView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.rest.AllCILevels;

@Path("/api/v1/environments/stages")
@AllCILevels
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
public interface EnvironmentStageApi extends ApiService {

    default String serviceName() {
        return "environmentStageApi";
    }

    @POST
    EnvironmentStageView createStage(EnvironmentStageForm stageForm);

    @GET
    @Path("/{environmentStageId:.*/EnvironmentStage[^/]*}")
    EnvironmentStageView getStageById(@PathParam("environmentStageId") String environmentStageId);

    @PUT
    @Path("/{environmentStageId:.*/EnvironmentStage[^/]*}")
    EnvironmentStageView updateStage(@PathParam("environmentStageId") String environmentStageId, EnvironmentStageForm stageForm);

    @POST
    @Path("/search")
    List<EnvironmentStageView> searchStages(EnvironmentStageFilters filters);

    /**
     * Deletes an environment stage.
     *
     * @param environmentStageId the environment stage identifier
     */
    @DELETE
    @PublicApiMember
    @Path("/{environmentStageId:.*/EnvironmentStage[^/]*}")
    void delete(@PathParam("environmentStageId") String environmentStageId);

    /**
     * Creates a new environment stage.
     *
     * @param environmentStage an <code>EnvironmentStage</code> object describing the new environment category
     * @return created <code>EnvironmentStage</code> object
     */
    @PublicApiMember
    EnvironmentStage create(EnvironmentStage environmentStage);

    /**
     * Gets an environment category by id.
     *
     * @param environmentStageId the environment stage identifier
     * @return found <code>EnvironmentStage</code> object
     */
    @PublicApiMember
    EnvironmentStage getById(String environmentStageId);

    /**
     * Updates an existing environment stage.
     *
     * @param environmentCategory an <code>EnvironmentStage</code> object describing the new properties of the environment category
     * @return updated <code>EnvironmentStage</code> object
     */
    @PublicApiMember
    EnvironmentStage update(EnvironmentStage environmentCategory);

    /**
     * Searches environment stages by filters.
     *
     * @param filters an <code>EnvironmentStageFilters</code> object describing the search criteria
     * @return list of matching <code>EnvironmentStage</code>s
     */
    @PublicApiMember
    List<EnvironmentStage> search(EnvironmentStageFilters filters);
}
