/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.configuration.SystemMessageSettings;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.views.ConfigurationView;
import com.xebialabs.xlrelease.views.SharedConfigurationStatusResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;

@Path(value="/api/v1/config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
@AllCILevels
public interface ConfigurationApi
extends ApiService {
    public static final String SERVICE_NAME = "configurationApi";

    @Override
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Path(value="/Configuration/variables/global")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getGlobalVariables();

    @GET
    @Path(value="/Configuration/variableValues/global")
    @PublicApiMember
    public Map<String, String> getGlobalVariableValues();

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getGlobalVariable(@PathParam(value="variableId") String var1);

    @POST
    @Path(value="/Configuration/variables/global")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable addGlobalVariable(Variable var1);

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(@PathParam(value="variableId") String var1, com.xebialabs.xlrelease.domain.variables.Variable var2);

    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(com.xebialabs.xlrelease.domain.variables.Variable var1);

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public void deleteGlobalVariable(@PathParam(value="variableId") String var1);

    @PublicApiMember
    public List<? extends ConfigurationItem> searchByTypeAndTitle(String var1, String var2);

    @PublicApiMember
    public List<? extends ConfigurationItem> searchByTypeAndTitle(String var1, String var2, String var3);

    @GET
    @Path(value="byTypeAndTitle")
    @PublicApiMember
    public List<Configuration> searchByTypeAndTitle(@QueryParam(value="configurationType") String var1, @QueryParam(value="title") String var2, @QueryParam(value="folderId") String var3, @QueryParam(value="folderOnly") boolean var4);

    @GET
    @Path(value="/{configurationId:.*/Configuration[^/]*}")
    @PublicApiMember
    public Configuration getConfiguration(@PathParam(value="configurationId") String var1);

    @POST
    @PublicApiMember
    public Configuration addConfiguration(Configuration var1);

    @PUT
    @Path(value="{configurationId:.*/Configuration[^/]*}")
    public Configuration updateConfiguration(@PathParam(value="configurationId") String var1, Configuration var2);

    @PublicApiMember
    public Configuration updateConfiguration(Configuration var1);

    @DELETE
    @Path(value="{configurationId:.*/Configuration[^/]*}")
    @PublicApiMember
    public void deleteConfiguration(@PathParam(value="configurationId") String var1);

    @GET
    @Path(value="system-message")
    @PublicApiMember
    public SystemMessageSettings getSystemMessage();

    @PUT
    @Path(value="system-message")
    @PublicApiMember
    public SystemMessageSettings updateSystemMessage(SystemMessageSettings var1);

    @POST
    @Path(value="status")
    @PublicApiMember
    public SharedConfigurationStatusResponse checkStatus(ConfigurationView var1);

    @POST
    @Path(value="{configurationId:.*/Configuration[^/]*}/status")
    @PublicApiMember
    public SharedConfigurationStatusResponse checkStatus(@PathParam(value="configurationId") String var1);
}

