package com.xebialabs.xlrelease.api.v1;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.views.ExplodedDescriptor;


import java.util.List;

@Path("/api/v1/metadata")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface MetadataApi extends ApiService {

    default String serviceName() {
        return "metadataApi";
    }

    @GET
    @Path("types/{type}")
    ExplodedDescriptor findDescriptor(@PathParam("type") Type type);

    @GET
    @Path("types")
    List<ExplodedDescriptor> listAll();
}
