package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.views.RoleView;

/**
 * Operations related to roles.
 */
@Path("/api/v1/roles")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
public interface RolesApi extends ApiService {

    default String serviceName() {
        return "rolesApi";
    }

    /**
     * Returns the paginated list of roles ordered by role name.
     *
     * @param page           the page of results to return. Default value is 0.
     * @param resultsPerPage the number of results per page. Default value is 100. Maximum value is 100.
     * @return a list of roles.
     */
    @GET
    @PublicApiMember
    List<RoleView> getRoles(@DefaultValue("0") @QueryParam(PAGE) Integer page,
                            @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Integer resultsPerPage);


    @GET
    @Path("/{roleName:.*[^/]*}")
    @PublicApiMember
    RoleView getRole(@PathParam("roleName") String roleName);


    @POST
    @Path("/{roleName:.*[^/]*}")
    @PublicApiMember
    void create(@PathParam("roleName") String roleName, RoleView roleView);

    @POST
    @PublicApiMember
    void create(List<RoleView> roleViews);

    @PUT
    @Path("/{roleName:.*[^/]*}")
    @PublicApiMember
    void update(@PathParam("roleName") String roleName, RoleView roleView);

    @PUT
    @PublicApiMember
    void update(List<RoleView> roleViews);

    @DELETE
    @Path("/{roleName:.*[^/]*}")
    @PublicApiMember
    void delete(@PathParam("roleName") String roleName);

    @POST
    @Path("/{roleName:.*[^/]*}/rename")
    void rename(@PathParam("roleName") String roleName, @QueryParam("newName") String newName);
}
