/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.risk.configuration.RiskGlobalThresholds;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;

@Path(value="/api/v1/risks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface RiskApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "riskApi";
    }

    @GET
    @Path(value="/{riskId:.*/Risk}")
    @AllCILevels
    public Risk getRisk(@PathParam(value="riskId") String var1);

    @PublicApiMember
    public Risk getRisk(Release var1);

    @GET
    @Path(value="/config")
    @AllCILevels
    @PublicApiMember
    public RiskGlobalThresholds getRiskGlobalThresholds();

    @PUT
    @Path(value="/config")
    @AllCILevels
    @PublicApiMember
    public RiskGlobalThresholds updateRiskGlobalThresholds(RiskGlobalThresholds var1);

    @GET
    @Path(value="/profiles")
    @PublicApiMember
    public List<RiskProfile> getRiskProfiles();

    @GET
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*|new}")
    @PublicApiMember
    public RiskProfile getRiskProfile(@PathParam(value="riskProfileId") String var1);

    @PublicApiMember
    public RiskProfile getRiskProfileByTitle(String var1);

    @PUT
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*}")
    public RiskProfile updateRiskProfile(@PathParam(value="riskProfileId") String var1, RiskProfile var2);

    @PublicApiMember
    public RiskProfile updateRiskProfile(RiskProfile var1);

    @POST
    @Path(value="/profiles")
    @PublicApiMember
    public RiskProfile createRiskProfile(RiskProfile var1);

    @DELETE
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*}")
    public void deleteRiskProfile(@PathParam(value="riskProfileId") String var1);

    @PublicApiMember
    public void deleteRiskProfile(RiskProfile var1);

    @POST
    @Path(value="/profiles/{riskProfileId:.*/RiskProfile[^/]*}/copy")
    public RiskProfile copyRiskProfile(@PathParam(value="riskProfileId") String var1);

    @PublicApiMember
    public RiskProfile copyRiskProfile(RiskProfile var1);

    @GET
    @Path(value="/assessors")
    @AllCILevels
    @PublicApiMember
    public List<RiskAssessor> getAllRiskAssessors();
}

