package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.analytics.ProjectedRelease;

@Path("/api/v1/analytics/planner")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface PlannerApi extends ApiService {

    default String serviceName() {
        return "plannerApi";
    }

    @GET
    @Path("/active")
    List<ProjectedRelease> getActiveReleases(@DefaultValue("0") @QueryParam(PAGE) Long page,
                                             @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Long resultsPerPage,
                                             @DefaultValue("RELEASE") @QueryParam("kind") String kind);

    @GET
    @Path("/completed")
    List<ProjectedRelease> getCompletedReleases(@DefaultValue("0") @QueryParam(PAGE) Long page,
                                                @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Long resultsPerPage,
                                                @DefaultValue("0") @QueryParam("since") Long sinceMillis,
                                                @DefaultValue("RELEASE") @QueryParam("kind") String kind);

    @POST
    @Path("/byIds")
    List<ProjectedRelease> getReleasesByIds(List<String> releaseIds);
}
