package com.xebialabs.xlrelease.api.v1;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import org.springframework.data.domain.Page;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.WorkflowFilters;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.view.WorkflowOverview;

@Path("/api/v1/workflows")
@AllCILevels
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
public interface WorkflowApi extends ApiService {

    default String serviceName() {
        return "WorkflowApi";
    }

    @POST
    @Path("search")
    Page<WorkflowOverview> searchWorkflows(WorkflowFilters workflowFilters,
                                           @DefaultValue("0") @QueryParam(PAGE) int page,
                                           @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) int resultsPerPage);
}
