package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import javax.ws.rs.QueryParam;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.domain.udm.reporting.*;

/**
 * Operations on reporting records used by the audit report.
 */
@PublicApi
@ShowOnlyPublicApiMembers
public interface TaskReportingApi extends ApiService {

    String TASK_REPORTING_API = "taskReportingApi";

    default String serviceName() {
        return TASK_REPORTING_API;
    }

    List<TaskReportingRecord> addRecord(TaskReportingRecord record, @QueryParam("applyTaskAttributes") boolean applyTaskAttributes);

    /**
     * Adds a new reporting record.
     *
     * Available since Release 22.2.0, use <code>taskReportingApi.addRecord(record, False)</code> with older Release versions.
     *
     * @param record an <code>TaskReportingRecord</code> object describing the collected data.
     * @return the newly created record.
     */
    @PublicApiMember
    TaskReportingRecord addRecord(TaskReportingRecord record);

    /**
     * Factory method to create a new instance of an ITSM record.
     *
     * @return instance of the <code>ItsmRecord</code> type.
     */
    @PublicApiMember
    ItsmRecord newItsmRecord();

    /**
     * Factory method to create a new instance of a plan record.
     *
     * @return instance of the <code>PlanRecord</code> type.
     */
    @PublicApiMember
    PlanRecord newPlanRecord();

    /**
     * Factory method to create a new instance of a build record.
     *
     * @return instance of the <code>BuildRecord</code> type.
     */
    @PublicApiMember
    BuildRecord newBuildRecord();

    /**
     * Factory method to create a new instance of a deployment record.
     *
     * @return instance of the <code>DeploymentRecord</code> type.
     */
    @PublicApiMember
    DeploymentRecord newDeploymentRecord();

    /**
     * Factory method to create a new instance of a code compliance record.
     *
     * @return instance of the <code>CodeComplianceRecord</code> type.
     */
    @PublicApiMember
    CodeComplianceRecord newCodeComplianceRecord();

}
