package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentLabelForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentLabelView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.rest.AllCILevels;

@Path("/api/v1/environments/labels")
@AllCILevels
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
public interface EnvironmentLabelApi extends ApiService {

    default String serviceName() {
        return "environmentLabelApi";
    }

    @POST
    EnvironmentLabelView createLabel(EnvironmentLabelForm labelForm);

    @GET
    @Path("/{environmentLabelId:.*/EnvironmentLabel[^/]*}")
    EnvironmentLabelView getLabelById(@PathParam("environmentLabelId") String environmentLabelId);

    @PUT
    @Path("/{environmentLabelId:.*/EnvironmentLabel[^/]*}")
    EnvironmentLabelView updateLabel(@PathParam("environmentLabelId") String environmentLabelId, EnvironmentLabelForm labelForm);

    @POST
    @Path("/search")
    List<EnvironmentLabelView> searchLabels(EnvironmentLabelFilters filters);

    /**
     * Deletes an environment label.
     *
     * @param environmentLabelId the environment label identifier
     */
    @DELETE
    @PublicApiMember
    @Path("/{environmentLabelId:.*/EnvironmentLabel[^/]*}")
    void delete(@PathParam("environmentLabelId") String environmentLabelId);


    /**
     * Creates a new environment label.
     *
     * @param environmentLabel an <code>EnvironmentLabel</code> object describing the new environment label
     * @return created <code>EnvironmentLabel</code> object
     */
    @PublicApiMember
    EnvironmentLabel create(EnvironmentLabel environmentLabel);

    /**
     * Gets an environment label by id.
     *
     * @param id the environment label identifier
     * @return found <code>EnvironmentLabel</code> object
     */
    @PublicApiMember
    EnvironmentLabel getById(String id);

    /**
     * Updates an existing environment label.
     *
     * @param environmentLabel an <code>EnvironmentLabel</code> object describing the new properties of the environment label
     * @return updated <code>EnvironmentLabel</code> object
     */
    @PublicApiMember
    EnvironmentLabel update(EnvironmentLabel environmentLabel);

    /**
     * Searches environment labels by filters.
     *
     * @param filters an <code>EnvironmentTypeFilters</code> object describing the search criteria
     * @return list of matching <code>EnvironmentLabel</code>s
     */
    @PublicApiMember
    List<EnvironmentLabel> search(EnvironmentLabelFilters filters);

}
