package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.views.ManagedApplicationPage;
import com.xebialabs.xlrelease.api.v1.views.ManagedApplicationView;
import com.xebialabs.xlrelease.rest.AllCILevels;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path("/api/v1/managed-application")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
@AllCILevels
public interface ManagedApplicationApi extends ApiService {
    default String serviceName() {
        return "managedApplicationApi";
    }

    /**
     * Gets all managed applications defined by pagination data.
     *
     * @param folderId Folder ID under which the managed applications are set
     * @param page The number of the page
     * @param resultsPerPage The number of results per page
     * @param condition Filtering condition
     * @return All managed application for given folder
     */
    @GET
    @PublicApiMember
    ManagedApplicationPage getManagedApplications(
            @QueryParam("folderId") String folderId,
            @DefaultValue("0") @QueryParam(PAGE) Long page,
            @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Long resultsPerPage,
            @DefaultValue("") @QueryParam("condition") String condition
    );

    /**
     * Gets managed application by its id.
     *
     * @param managedApplicationId Managed application id
     * @return Managed application (if found) formatted to a view
     */
    @GET
    @Path("/{managedApplicationId}")
    @PublicApiMember
    ManagedApplicationView getManagedApplication(@PathParam("managedApplicationId") String managedApplicationId);

    /**
     * Saves a new managed application.
     *
     * @param managedApplication Managed application model
     * @return Created instance of managed application formatted to a view
     */
    @POST
    @PublicApiMember
    ManagedApplicationView addManagedApplication(ManagedApplicationView managedApplication);

    /**
     * Updates an existing managed application.
     *
     * @param managedApplication Managed application model to update
     * @return Updated managed application model
     */
    @PUT
    @PublicApiMember
    ManagedApplicationView updateManagedApplication(ManagedApplicationView managedApplication);

    /**
     * Deletes a managed application by id.
     *
     * @param managedApplicationId The managed application to delete
     */
    @DELETE
    @Path("/{managedApplicationId}")
    @PublicApiMember
    void deleteManagedApplication(@PathParam("managedApplicationId") String managedApplicationId);

    /**
     * Creates managed applications from external deployments webhook source
     *
     * @param webhookSourceId The webhook source id of created webhook source
     */
    @POST
    @Path("/create-from-webhook-source/{webhookSourceId:.*/Configuration[^/]*}")
    @PublicApiMember
    void createManagedApplicationsFromWebhookSource(@PathParam("webhookSourceId") String webhookSourceId);
}
