package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;

/**
 * Operations on release groups.
 */
@Path("/api/v1/release-groups")
@Produces({MediaType.APPLICATION_JSON})
@Consumes({MediaType.APPLICATION_JSON})
public interface ReleaseGroupApi extends ApiService {

    default String serviceName() {
        return "releaseGroupApi";
    }

    @GET
    @Path("/{groupId:.*ReleaseGroup[^/]*}")
    ReleaseGroup getGroup(@PathParam("groupId") String groupId);

    @DELETE
    @Path("/{groupId:.*ReleaseGroup[^/]*}")
    void deleteGroup(@PathParam("groupId") String groupId);

    @POST
    ReleaseGroup createGroup(ReleaseGroup releaseGroup);

    @PUT
    @Path("/{groupId:.*ReleaseGroup[^/]*}")
    ReleaseGroup updateGroup(@PathParam("groupId") String groupId, ReleaseGroup releaseGroup);

    @GET
    @Path("/{groupId:.*ReleaseGroup[^/]*}/members")
    List<String> getMembers(@PathParam("groupId") String groupId);

    @POST
    @Path("/{groupId:.*ReleaseGroup[^/]*}/members")
    void addMembersToGroup(@PathParam("groupId") String groupId, List<String> memberIds);

    @DELETE
    @Path("/{groupId:.*ReleaseGroup[^/]*}/members")
    void removeMembersFromGroup(@PathParam("groupId") String groupId, List<String> memberIds);

    @POST
    @Path("search")
    List<ReleaseGroup> searchGroups(ReleaseGroupFilters groupFilters,
                                    @DefaultValue("0") @QueryParam(PAGE) Long page,
                                    @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Long resultsPerPage,
                                    @DefaultValue("RISK") @QueryParam(ORDER_BY) ReleaseGroupOrderMode orderBy);

    @GET
    @Path("/{groupId:.*ReleaseGroup[^/]*}/timeline")
    ReleaseGroupTimeline getReleaseGroupTimeline(@PathParam("groupId") String groupId);
}
