package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.api.v1.form.ApplicationForm;
import com.xebialabs.xlrelease.api.v1.views.ApplicationView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.rest.AllCILevels;

@Path("/api/v1/applications")
@AllCILevels
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
public interface ApplicationApi extends ApiService {

    default String serviceName() {
        return "applicationApi";
    }

    @POST
    ApplicationView createApplication(ApplicationForm applicationForm);

    @GET
    @Path("/{applicationId:.*/Application[^/]*}")
    ApplicationView getApplication(@PathParam("applicationId") String applicationId);

    @PUT
    @Path("/{applicationId:.*/Application[^/]*}")
    ApplicationView updateApplication(@PathParam("applicationId") String applicationId, ApplicationForm applicationForm);

    @POST
    @Path("/search")
    List<ApplicationView> searchApplications(ApplicationFilters applicationFilters);

    /**
     * Deletes an application.
     *
     * @param applicationId the application identifier
     */
    @DELETE
    @PublicApiMember
    @Path("/{applicationId:.*/Application[^/]*}")
    void deleteApplication(@PathParam("applicationId") String applicationId);

    /**
     * Creates a new application.
     *
     * @param application an <code>Application</code> object describing the new application
     * @return created <code>Application</code> object
     */
    @PublicApiMember
    Application create(Application application);

    /**
     * Gets an application by id.
     *
     * @param applicationId the application identifier
     * @return found <code>Application</code> object
     */
    @PublicApiMember
    Application getById(String applicationId);

    /**
     * Updates an existing application.
     *
     * @param application an <code>Application</code> object describing the new properties of the application
     * @return updated <code>Application</code> object
     */
    @PublicApiMember
    Application update(Application application);

    /**
     * Searches applications by filters.
     *
     * @param filters an <code>ApplicationFilters</code> object describing the search criteria
     * @return list of matching <code>Application</code>s
     */
    @PublicApiMember
    List<Application> search(ApplicationFilters filters);

}
