/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CopyTemplate;
import com.xebialabs.xlrelease.api.v1.forms.CreateRelease;
import com.xebialabs.xlrelease.api.v1.forms.StartRelease;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileUploadException;

@Path(value="/api/v1/templates")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface TemplateApi
extends ApiService {
    public static final String SERVICE_NAME = "templateApi";

    @Override
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @PublicApiMember
    public List<Release> getTemplates(@QueryParam(value="title") String var1, @QueryParam(value="tag") List<String> var2, @DefaultValue(value="0") @QueryParam(value="page") Long var3, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var4, @DefaultValue(value="1") @QueryParam(value="depth") Integer var5);

    @Deprecated
    @PublicApiMember
    public List<Release> getTemplates(String var1);

    @PUT
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public Release updateTemplate(@PathParam(value="templateId") String var1, Release var2);

    @PublicApiMember
    public Release updateTemplate(Release var1);

    @POST
    @PublicApiMember
    public Release createTemplate(Release var1, @QueryParam(value="folderId") String var2);

    @POST
    @Path(value="/import")
    @Consumes(value={"application/json"})
    @PublicApiMember
    public List<ImportResult> importTemplate(String var1, @QueryParam(value="folderId") String var2, @QueryParam(value="version") String var3);

    @PublicApiMember
    public List<ImportResult> importTemplate(String var1, String var2);

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    public List<ImportResult> importTemplateAsXlr(@Context HttpServletRequest var1, @QueryParam(value="folderId") String var2) throws IOException, FileUploadException;

    @GET
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public Release getTemplate(@PathParam(value="templateId") String var1);

    @DELETE
    @Path(value="/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public void deleteTemplate(@PathParam(value="templateId") String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/create")
    @PublicApiMember
    public Release create(@PathParam(value="templateId") String var1, CreateRelease var2);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/start")
    @PublicApiMember
    public Release start(@PathParam(value="templateId") String var1, StartRelease var2);

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(@PathParam(value="templateId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="variableId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/possibleValues")
    @PublicApiMember
    public Collection<Object> getVariablePossibleValues(@PathParam(value="variableId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/used")
    @PublicApiMember
    public Boolean isVariableUsed(@PathParam(value="variableId") String var1);

    @POST
    @Path(value="/{variableId:.*/Variable[^/]*}/replace")
    @PublicApiMember
    public void replaceVariable(@PathParam(value="variableId") String var1, VariableOrValue var2);

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public void deleteVariable(@PathParam(value="variableId") String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/variables")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="templateId") String var1, Variable var2);

    @PUT
    @Path(value="/{releaseId:.*Release[^/]*}/variables")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(@PathParam(value="releaseId") String var1, List<com.xebialabs.xlrelease.domain.variables.Variable> var2);

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="variableId") String var1, com.xebialabs.xlrelease.domain.variables.Variable var2);

    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable var1);

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions();

    @GET
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="templateId") String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/teams")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="templateId") String var1, List<TeamView> var2);

    @GET
    @Path(value="zip/{templateId:.*Release[^/]*}")
    @PublicApiMember
    @Produces(value={"application/octet-stream"})
    public Response exportTemplateToZip(@PathParam(value="templateId") @IdParam String var1);

    @POST
    @Path(value="/{templateId:.*Release[^/]*}/copy")
    public Release copyTemplate(@PathParam(value="templateId") String var1, CopyTemplate var2);

    @PublicApiMember
    public Release copyTemplate(String var1, String var2, String var3);
}

