/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.rest.AllCILevels;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/api/v1/phases")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface PhaseApi
extends ApiService {
    public static final String SERVICE_NAME = "phaseApi";

    @Override
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @PublicApiMember
    public Phase getPhase(@PathParam(value="phaseId") String var1);

    @PUT
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    public Phase updatePhase(@PathParam(value="phaseId") String var1, Phase var2);

    @PublicApiMember
    public Phase updatePhase(Phase var1);

    @POST
    @Path(value="/{containerId:.*/Phase.*?}/tasks")
    @PublicApiMember
    public Task addTask(@PathParam(value="containerId") String var1, Task var2, @QueryParam(value="position") Integer var3);

    @GET
    @Path(value="/byTitle")
    @PublicApiMember
    public List<Phase> searchPhasesByTitle(@QueryParam(value="phaseTitle") String var1, @QueryParam(value="releaseId") String var2);

    @GET
    @Path(value="/search")
    @PublicApiMember
    public List<Phase> searchPhases(@QueryParam(value="phaseTitle") String var1, @QueryParam(value="releaseId") String var2, @QueryParam(value="phaseVersion") PhaseVersion var3);

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/phase")
    @PublicApiMember
    public Phase addPhase(@PathParam(value="releaseId") String var1, Phase var2, @QueryParam(value="position") Integer var3);

    @POST
    @Path(value="/{phaseId:.*/Phase[^/]*}/copy")
    @PublicApiMember
    public Phase copyPhase(@PathParam(value="phaseId") String var1, @QueryParam(value="targetPosition") int var2);

    @PublicApiMember
    public Phase addPhase(String var1, Phase var2);

    @PublicApiMember
    public Phase newPhase();

    @PublicApiMember
    public Phase newPhase(String var1);

    @DELETE
    @Path(value="/{phaseId:.*/Phase[^/]*}")
    @PublicApiMember
    public void deletePhase(@PathParam(value="phaseId") String var1);
}

