package com.xebialabs.xlrelease.api.v1.form;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;

public class EnvironmentReservationForm {
    private Date startDate;
    private Date endDate;
    private String note;
    private String environmentId;
    private List<String> applicationIds = null;

    public EnvironmentReservation toEnvironmentReservation() {
        EnvironmentReservation reservation = new EnvironmentReservation();
        reservation.setId(null);
        reservation.setStartDate(startDate);
        reservation.setEndDate(endDate);
        reservation.setNote(note);
        Environment environment = new Environment();
        environment.setId(environmentId);
        reservation.setEnvironment(environment);

        if (applicationIds != null) {
            List<Application> apps = applicationIds
                    .stream()
                    .map(id -> Type.valueOf(Application.class).getDescriptor().<Application>newInstance(id))
                    .collect(Collectors.toList());

            reservation.setApplications(apps);
        }

        return reservation;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public String getNote() {
        return note;
    }

    public void setNote(final String note) {
        this.note = note;
    }

    public String getEnvironmentId() {
        return environmentId;
    }

    public void setEnvironmentId(final String environmentId) {
        this.environmentId = environmentId;
    }

    public List<String> getApplicationIds() {
        return applicationIds;
    }

    public void setApplicationIds(final List<String> applicationIds) {
        this.applicationIds = applicationIds;
    }
}
