package com.xebialabs.xlrelease.api.v1.views;

import java.util.Date;

import com.xebialabs.xlrelease.domain.Phase;

public class PhaseTimeline extends PlanItemTimeline {

    private String color;

    private String currentTask;

    public PhaseTimeline(Phase phase, Date plannedStartDate, Date plannedEndDate) {
        super(phase, plannedStartDate, plannedEndDate);
        this.color = phase.getColor();
        if (phase.hasCurrentTask()) {
            this.currentTask = phase.getCurrentTask().getTitle();
        }
    }

    public String getColor() {
        return color;
    }

    public void setColor(final String color) {
        this.color = color;
    }

    public String getCurrentTask() {
        return currentTask;
    }

    public void setCurrentTask(final String currentTask) {
        this.currentTask = currentTask;
    }
}
