package com.xebialabs.xlrelease.api.v1.forms;

import java.io.Serializable;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.ExternalVariableServer;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.StringVariable;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;

import static com.xebialabs.xlrelease.variable.VariableHelper.withoutVariableSyntax;

/**
 * A variable in release or template.
 */
@PublicApiRef
public class Variable implements Serializable {
    static final String XLRELEASE_STRING_VARIABLE = Type.valueOf(StringVariable.class).toString();

    private String id;
    private String key;
    private String type = XLRELEASE_STRING_VARIABLE;
    private boolean requiresValue = true;
    private boolean showOnReleaseStart = true;
    private Object value;
    private String label;
    private String description;
    private boolean multiline = false;
    private String referencedType;
    private boolean inherited = false;
    private boolean preventInterpolation = false;

    private ExternalVariableValue externalVariableValue;

    private ValueProviderConfiguration valueProvider;

    public Variable() {
    }

    public Variable(String key, String value) {
        this(key, value, true);
    }

    public Variable(String key, String value, boolean required) {
        this(XLRELEASE_STRING_VARIABLE, key, value, required);
    }

    public Variable(String type, String key, Object value, boolean required) {
        this.type = type;
        this.key = key;
        this.value = value;
        this.requiresValue = required;
        this.showOnReleaseStart = required;
    }

    public com.xebialabs.xlrelease.domain.variables.Variable toReleaseVariable() {
        if (key == null) {
            throw new IllegalArgumentException("Variable key must be defined");
        }
        com.xebialabs.xlrelease.domain.variables.Variable variable = Type.valueOf(type).getDescriptor().newInstance(id);
        variable.setKey(withoutVariableSyntax(key));
        variable.setRequiresValue(requiresValue);
        variable.setShowOnReleaseStart(showOnReleaseStart);
        variable.setUntypedValue(value);
        variable.setLabel(label);
        variable.setDescription(description);
        variable.setValueProvider(this.getValueProvider());
        if (variable.hasProperty("multiline")) {
            variable.setProperty("multiline", this.multiline);
        }
        if (variable.hasProperty("referencedType")) {
            variable.setProperty("referencedType", this.referencedType);
        }

        if (externalVariableValue != null && variable instanceof PasswordStringVariable) {
            final PasswordStringVariable passwordVariable = (PasswordStringVariable) variable;

            String variableServerId = this.externalVariableValue.getServer();
            String variableServerType = this.externalVariableValue.getServerType();

            ExternalVariableServer variableServer = Type.valueOf(variableServerType).getDescriptor().newInstance(variableServerId);

            final String path = this.externalVariableValue.getPath();
            final String externalKey = this.externalVariableValue.getExternalKey();

            final com.xebialabs.xlrelease.domain.variables.ExternalVariableValue externalValue =
                    new com.xebialabs.xlrelease.domain.variables.ExternalVariableValue(variableServer, path, externalKey);

            passwordVariable.setExternalVariableValue(externalValue);
        }

        if (variable instanceof StringVariable) {
            ((StringVariable) variable).setPreventInterpolation(this.preventInterpolation);
        }

        variable.setInherited(inherited);
        return variable;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getKey() {
        return key;
    }

    public void setKey(final String key) {
        this.key = key;
    }

    public String getType() {
        return type;
    }

    public void setType(final String type) {
        this.type = type;
    }

    public boolean isRequiresValue() {
        return requiresValue;
    }

    public void setRequiresValue(final boolean requiresValue) {
        this.requiresValue = requiresValue;
    }

    public boolean isShowOnReleaseStart() {
        return showOnReleaseStart;
    }

    public void setShowOnReleaseStart(final boolean showOnReleaseStart) {
        this.showOnReleaseStart = showOnReleaseStart;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(final Object value) {
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ValueProviderConfiguration getValueProvider() {
        return valueProvider;
    }

    public void setValueProvider(final ValueProviderConfiguration valueProvider) {
        this.valueProvider = valueProvider;
    }

    public boolean isMultiline() {
        return multiline;
    }

    public void setMultiline(final boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isInherited() {
        return inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public ExternalVariableValue getExternalVariableValue() {
        return externalVariableValue;
    }

    public void setExternalVariableValue(final ExternalVariableValue externalVariableValue) {
        this.externalVariableValue = externalVariableValue;
    }

    public boolean isPreventInterpolation() {
        return preventInterpolation;
    }

    public void setPreventInterpolation(boolean preventInterpolation) {
        this.preventInterpolation = preventInterpolation;
    }

    public String getReferencedType() {
        return referencedType;
    }

    public void setReferencedType(String referencedType) {
        this.referencedType = referencedType;
    }
}
