package com.xebialabs.xlrelease.api.v1.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;

import static java.util.Arrays.asList;

public class ReleaseGroupFilters implements Serializable {
    private String title = "";
    private String folderId = "";
    private List<ReleaseGroupStatus> statuses = new ArrayList<>();

    public ReleaseGroupFilters withTitle(String title) {
        this.title = title;
        return this;
    }

    public ReleaseGroupFilters withStatuses(ReleaseGroupStatus... statuses) {
        this.statuses = asList(statuses);
        return this;
    }

    public ReleaseGroupFilters withFolderId(String folderId) {
        this.folderId = folderId;
        return this;
    }


    public boolean hasStatuses() {
        return statuses != null && !statuses.isEmpty();
    }

    // getters / setters

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public List<ReleaseGroupStatus> getStatuses() {
        return statuses;
    }

    public void setStatuses(final List<ReleaseGroupStatus> statuses) {
        this.statuses = statuses;
    }

}
