package com.xebialabs.xlrelease.api.v1.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.repository.Ids;

import static com.xebialabs.deployit.booter.local.utils.Strings.isNotBlank;
import static com.xebialabs.deployit.checks.Checks.checkArgument;

@PublicApiRef
public class FacetFilters {
    private String parentId;
    private String targetId;
    private List<Type> types = new ArrayList<>();

    public FacetFilters() {
    }

    public FacetFilters(final String parentId, final String targetId, final List<Type> types) {
        this.parentId = parentId;
        this.targetId = targetId;
        this.types = types;
    }

    public void validate() {
        checkArgument(hasParentId() || hasTargetId(), "Please specify targetId or parentId.");
        checkArgument(!hasParentId() || Ids.isReleaseId(getParentId()), "Parent ID is not a valid release ID.");
    }

    public boolean hasParentId() {
        return parentId != null && isNotBlank(parentId);
    }

    public boolean hasTargetId() {
        return targetId != null && isNotBlank(targetId);
    }

    public FacetFilters withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public FacetFilters withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public FacetFilters withType(Type... types) {
        this.types = Arrays.asList(types);
        return this;
    }

    public FacetFilters includingType(String type) {
        if (this.types == null) {
           withType(Type.valueOf(type));
        } else {
            this.types.add(Type.valueOf(type));
        }
        return this;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(final String parentId) {
        this.parentId = parentId;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(final String targetId) {
        this.targetId = targetId;
    }

    public List<Type> getTypes() {
        return types;
    }

    public void setTypes(final List<Type> types) {
        this.types = types;
    }
}
