package com.xebialabs.xlrelease.api.v1.filter;

import java.time.Duration;
import java.util.Date;
import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

@PublicApiRef
public class ReservationFilters {
    private String environmentTitle;
    private List<String> stages;
    private List<String> labels;
    private List<String> applications;
    private Date from;
    private Date to;

    public ReservationFilters() {
    }

    public ReservationFilters(final String environmentTitle, final List<String> stages, final List<String> labels, final List<String> applications, final Date from, final Date to) {
        this.environmentTitle = environmentTitle;
        this.stages = stages;
        this.labels = labels;
        this.applications = applications;
        this.from = from;
        this.to = to;
    }

    public void validate() {
        checkArgument(from != null, "Start date is required");
        checkArgument(to != null, "End date is required");
        checkArgument(from.before(to), "Start date must be before the end date");
        checkArgument(Duration.between(from.toInstant(), to.toInstant()).toDays() <= 90, "Start date and end date must be 90 or less days apart");
    }

    public String getEnvironmentTitle() {
        return environmentTitle;
    }

    public void setEnvironmentTitle(final String environmentTitle) {
        this.environmentTitle = environmentTitle;
    }

    public List<String> getStages() {
        return stages;
    }

    public void setStages(final List<String> stages) {
        this.stages = stages;
    }

    public List<String> getApplications() {
        return applications;
    }

    public void setApplications(final List<String> applications) {
        this.applications = applications;
    }

    public List<String> getLabels() {
        return labels;
    }

    public void setLabels(final List<String> labels) {
        this.labels = labels;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(final Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(final Date to) {
        this.to = to;
    }
}
