package com.xebialabs.xlrelease.api.v1.views;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;

public class EnvironmentReservationView {
    private String id;
    private Date startDate;
    private Date endDate;
    private String note;
    private EnvironmentView environment;
    private List<BaseApplicationView> applications = new ArrayList<>();

    public static EnvironmentReservationView fromEnvironmentReservation(EnvironmentReservation reservation) {
        EnvironmentReservationView view = new EnvironmentReservationView();
        view.setId(reservation.getId());
        view.setStartDate(reservation.getStartDate());
        view.setEndDate(reservation.getEndDate());
        view.setNote(reservation.getNote());
        view.setEnvironment(EnvironmentView.fromEnvironment(reservation.getEnvironment()));
        view.applications = reservation.getApplications()
                .stream()
                .map(BaseApplicationView::fromApplication)
                .collect(Collectors.toList());
        return view;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public String getNote() {
        return note;
    }

    public void setNote(final String note) {
        this.note = note;
    }

    public EnvironmentView getEnvironment() {
        return environment;
    }

    public void setEnvironment(final EnvironmentView environment) {
        this.environment = environment;
    }

    public List<BaseApplicationView> getApplications() {
        return applications;
    }

    public void setApplications(final List<BaseApplicationView> applications) {
        this.applications = applications;
    }
}
