package com.xebialabs.xlrelease.search;

import java.util.HashMap;
import java.util.Map;

import com.xebialabs.xlrelease.domain.status.ReleaseStatus;


public class ReleaseCountResults {
    private ReleaseCountResult live;
    private ReleaseCountResult archived;
    private ReleaseCountResult all;

    public ReleaseCountResults(Map<ReleaseStatus, Integer> live,
                               Map<ReleaseStatus, Integer> archived) {
        this.live = new ReleaseCountResult(live);
        this.archived = new ReleaseCountResult(archived);
        Map<ReleaseStatus, Integer> all = new HashMap<>(live);
        archived.forEach((key, value) -> all.merge(key, value, Integer::sum));
        this.all = new ReleaseCountResult(all);
    }

    public ReleaseCountResult getLive() {
        return live;
    }

    public ReleaseCountResult getArchived() {
        return archived;
    }

    public ReleaseCountResult getAll() {
        return all;
    }
}
