package com.xebialabs.xlrelease.api.v1.filter;

import java.util.ArrayList;
import java.util.List;
import jakarta.ws.rs.QueryParam;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public class TriggerFilters {

    @QueryParam("triggerTitle")
    private String triggerTitle;

    @QueryParam("templateTitle")
    private String templateTitle;

    @QueryParam("folderTitle")
    private String folderTitle;

    @QueryParam("folderId")
    private String folderId;

    @QueryParam("templateId")
    private String templateId;

    private Boolean nestedFolders = false;

    @QueryParam("triggerType")
    private List<String> triggerType = new ArrayList<>();

    public TriggerFilters() {
        this.triggerTitle = "";
        this.templateTitle = "";
        this.templateId = "";
    }

    public TriggerFilters(final String triggerTitle, final String templateTitle) {
        this.triggerTitle = triggerTitle;
        this.templateTitle = templateTitle;
    }

    public String getTriggerTitle() {
        return triggerTitle;
    }

    public void setTriggerTitle(final String triggerTitle) {
        this.triggerTitle = triggerTitle;
    }

    public String getTemplateTitle() {
        return templateTitle;
    }

    public void setTemplateTitle(final String templateTitle) {
        this.templateTitle = templateTitle;
    }

    public String getFolderTitle() {
        return folderTitle;
    }

    public void setFolderTitle(final String folderTitle) {
        this.folderTitle = folderTitle;
    }

    public List<String> getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(final List<String> triggerType) {
        this.triggerType = triggerType;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(final String templateId) {
        this.templateId = templateId;
    }

    public Boolean getNestedFolders() {
        return nestedFolders;
    }

    public void setNestedFolders(final Boolean nestedFolders) {
        this.nestedFolders = nestedFolders;
    }
}
