package com.xebialabs.xlrelease.api.v1.views;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.xlrelease.domain.environments.Application;

public class ApplicationView extends BaseAppEnvView {
    private List<BaseEnvironmentView> environments = new ArrayList<>();

    public static ApplicationView fromApplication(Application application) {
        ApplicationView view = new ApplicationView();
        view.setId(application.getId());
        view.setTitle(application.getTitle());
        view.setFolderId(application.getFolderId());
        view.environments = application.getEnvironments()
                .stream()
                .map(BaseEnvironmentView::fromEnvironment)
                .collect(Collectors.toList());
        return view;
    }

    public List<BaseEnvironmentView> getEnvironments() {
        return environments;
    }

    public void setEnvironments(final List<BaseEnvironmentView> environments) {
        this.environments = environments;
    }
}
