package com.xebialabs.xlrelease.api.v1.views;

import java.util.Date;
import java.util.List;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public class DeliveryTimeline {
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    private String title;

    private List<ReleaseTimeline> releases;

    private Date startDate;

    private Date endDate;

    public DeliveryTimeline(Delivery delivery) {
        this.id = delivery.getId();
        this.title = delivery.getTitle();
        this.startDate = delivery.getStartDate();
        this.endDate = delivery.getEndDate();
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public List<ReleaseTimeline> getReleases() {
        return releases;
    }

    public void setReleases(final List<ReleaseTimeline> releases) {
        this.releases = releases;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }
}
